/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.base;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWServerException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.IVWAdaptor;
import filenet.vw.integrator.base.IVWAdaptorThread;
import filenet.vw.integrator.base.VWAdaptorControlEx;
import filenet.vw.integrator.base.VWResources;
import filenet.vw.server.VWCallbackHandler;
import filenet.vw.server.VWCapsule;
import filenet.vw.server.VWLoginModule;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

public class VWAdaptorEx
extends Thread
implements IVWAdaptorThread {
    protected String m_queueName = null;
    protected String component_descriptor = null;
    protected VWXMLWrapper component_descriptor_doc = null;
    public boolean done = false;
    private boolean bIsIdle = true;
    protected IVWAdaptor adaptor = null;
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator.Dispatcher");
    protected long startTime = 0L;
    protected Object statsSyncObj = new Object();
    protected double callTime = 0.0;
    protected double callCount = 0.0;
    public String m_className = "VWAdaptorEx:";
    public String m_status = null;
    protected String exception_submap = null;
    protected String adaptor_class_name = null;
    private HashMap queueSignature = new HashMap();
    private static String g_ClientName = null;
    private VWSession session = null;
    private String connection_point = null;
    public int m_index = 1;
    public String m_id = null;
    public VWAdaptorControlEx m_parent = null;
    VWQueueDefinition qdef = null;
    protected DateFormat df = DateFormat.getDateTimeInstance(1, 1);
    public VWStepElement se = null;
    public String wobId = null;
    private LoginContext lc = null;
    private Object hasWorkObject = new Object();
    private long currentExecutionStartTime = -1L;

    public static String _get_FILE_DATE() {
        return "3/30/2011";
    }

    public static String _get_FILE_AUTHOR() {
        return "Quynh Dang";
    }

    public static String _get_FILE_REVISION() {
        return "dts937818/scm937878;scm943308-dts927184;scm952283/dts952264";
    }

    public synchronized void setAvailableAgain() {
        this.se = null;
        this.bIsIdle = true;
    }

    public static String getClientName() {
        if (g_ClientName == null) {
            try {
                g_ClientName = InetAddress.getLocalHost().getHostName() + "(" + InetAddress.getLocalHost().getHostAddress() + ") ";
            }
            catch (Exception e) {
                g_ClientName = "localhost ";
            }
        }
        return g_ClientName;
    }

    public VWAdaptorEx(VWQueue queue, String component_descriptor, int index, VWAdaptorControlEx parent) throws Exception {
        String m_method = "<init>";
        this.setDaemon(true);
        this.m_queueName = queue.toString();
        this.m_id = this.m_queueName + "[" + index + "]";
        this.m_className = this.m_className + this.m_id;
        this.setName(this.m_className);
        this.m_index = index;
        this.m_parent = parent;
        logger.entering(this.m_className, "<init>");
        this.qdef = queue.fetchQueueDefinition();
        this.component_descriptor = component_descriptor;
        this.component_descriptor_doc = new VWXMLWrapper(component_descriptor);
        this.connection_point = queue.getServiceSession().getConnectionPointName();
        System.getProperties().setProperty("filenet.pe.cm.connectionPoint", this.connection_point);
        logger.exiting(this.m_className, "<init>");
    }

    public String getLocaleDateStringNow() {
        return this.df.format(new Date());
    }

    protected static int get_max_polling_rate(int default_polling_rate) {
        int max_polling_rate = default_polling_rate;
        try {
            String s = JVMSystemConstants.GetPrivilegedSystemProperty("filenet.pe.cm.max.polling.interval");
            if (s != null) {
                max_polling_rate = Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return max_polling_rate;
    }

    protected static int get_polling_increment() {
        int polling_increment = 15000;
        try {
            String s = System.getProperty("filenet.pe.cm.polling.increment");
            if (s != null) {
                polling_increment = Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return polling_increment;
    }

    public synchronized void startWork(VWStepElement se) {
        this.se = se;
        if (se != null) {
            try {
                this.wobId = se.getWorkObjectNumber();
                this.bIsIdle = false;
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "startWork", this.m_id + " GIVEN " + this.wobId);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.notifyAll();
    }

    public synchronized boolean gotWork() {
        block7: {
            String m_method = "gotWork";
            try {
                if (this.se == null) {
                    this.bIsIdle = true;
                    this.wobId = null;
                    Thread.currentThread().setName(this.m_className);
                    this.m_status = VWResources.VWS_ADAPTOR_RUN_WAITING_FOR_WORK.toString(this.m_id, this.getLocaleDateStringNow());
                    if (logger.isFinest()) {
                        logger.finest(this.m_className, "gotWork", this.m_status);
                    }
                    this.wait();
                }
                if (this.done) {
                    return false;
                }
                if (this.se != null) {
                    Thread.currentThread().setName(this.m_className + ":" + this.wobId);
                    return true;
                }
            }
            catch (Throwable t) {
                this.done = true;
                this.m_status = VWResources.VWS_ADAPTOR_RUN_WAITING_FOR_WORK_GOT_EX.toString(this.m_id, VWException.DescribeThrowableCompletely(t), this.getLocaleDateStringNow());
                if (!logger.isFinest()) break block7;
                logger.finest(this.m_className, "gotWork", this.m_status);
            }
        }
        if (logger.isFinest()) {
            logger.finest(this.m_className, "gotWork", "NOWORK");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String m_method = "run";
        logger.entering(this.m_className, m_method);
        logger.finest(this.m_className, m_method, "USING THE NEW ADAPTOR!");
        try {
            this.init();
        }
        catch (Throwable t) {
            if (logger.isFinest()) {
                logger.throwing(this.m_className, m_method, t);
            }
            this.done = true;
            return;
        }
        while (!this.done) {
            block40: {
                Object opname;
                if (!this.gotWork()) continue;
                String workflowName = null;
                String signature = null;
                try {
                    if (this.session != null) {
                        VWClassFactory.setSession(this.session, this.se, 234L);
                    }
                    opname = this.se.getOperationName();
                    workflowName = this.se.getWorkflowName();
                    this.m_status = VWResources.VWS_ADAPTOR_RUN_PROCESSINGSTEPELEMENT.toString(new Object[]{this.m_id, this.wobId, workflowName, opname, this.getLocaleDateStringNow()});
                    HashMap<String, String> signatures = (HashMap<String, String>)this.queueSignature.get(this.m_queueName);
                    if (signatures == null) {
                        signatures = new HashMap<String, String>();
                        this.queueSignature.put(this.m_queueName, signatures);
                    }
                    if ((signature = (String)signatures.get(opname)) == null) {
                        VWAttributeInfo ai;
                        VWOperationDefinition opdef = null;
                        opdef = this.qdef.getOperation((String)opname);
                        if (opdef != null && (ai = opdef.getAttributeInfo()) != null) {
                            String operation_descriptor = (String)ai.getFieldValue("F_OperationDescriptor");
                            VWXMLWrapper operation_descriptor_doc = new VWXMLWrapper(operation_descriptor);
                            signature = VWXMLWrapper.getNodeValue(operation_descriptor_doc.getRootNode(), "signature");
                            signatures.put((String)opname, signature);
                        }
                    }
                    this.m_status = VWResources.VWS_ADAPTOR_RUN_PROCESSINGSTEPELEMENT.toString(new Object[]{this.m_id, this.wobId, workflowName, signature, this.getLocaleDateStringNow()});
                    long tempCallTime = System.currentTimeMillis();
                    AdaptorAction action = new AdaptorAction(this.adaptor, this.se, signature);
                    Object result = null;
                    try {
                        this.currentExecutionStartTime = System.currentTimeMillis();
                        Subject.doAsPrivileged(this.lc.getSubject(), action, null);
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                    Object pae = this.statsSyncObj;
                    synchronized (pae) {
                        this.callTime += (double)(System.currentTimeMillis() - tempCallTime);
                        this.callCount += 1.0;
                    }
                    try {
                        this.se.doDispatch();
                        this.m_status = VWResources.VWS_ADAPTOR_RUN_DISPATCHEDSTEPELEMENTOK.toString(new Object[]{this.m_id, this.wobId, workflowName, signature, this.getLocaleDateStringNow()});
                        logger.info(this.m_className, m_method, this.m_status);
                    }
                    catch (VWException ex) {
                        String cause = " !!! FAILED in dispatching !!! due to " + VWException.DescribeThrowableAndItsCause(ex);
                        boolean shouldRetry = false;
                        if (ex instanceof VWServerException) {
                            long errTuple = ((VWServerException)ex).getTuple();
                            boolean bl = shouldRetry = errTuple == -714276852L || errTuple == -714276820L;
                        }
                        if (shouldRetry) {
                            VWParameter resultParam;
                            int nParams;
                            if (logger.isFinest()) {
                                logger.finest(this.m_className, m_method, "RELOCK the step element because the initial dispatch failed with " + cause);
                            }
                            String resultName = null;
                            Object resultValue = null;
                            VWParameter[] se_params = this.se.getParameters(767, 1);
                            int n = nParams = se_params == null ? 0 : se_params.length;
                            if (nParams > 0 && (resultParam = se_params[se_params.length - 1]).getMode() != 1) {
                                resultName = resultParam.getName();
                                resultValue = this.se.getParameterValue(resultName);
                            }
                            try {
                                this.se.doLock(true);
                                if (resultName != null && resultValue != null) {
                                    if (logger.isFinest()) {
                                        logger.finest(this.m_className, m_method, "Resetting " + resultName + "=" + Logger.asString(resultValue));
                                    }
                                    this.se.setParameterValue(resultName, resultValue, true);
                                }
                                this.se.doDispatch();
                            }
                            catch (Throwable t2) {
                                this.m_status = VWResources.VWS_ADAPTOR_STATUS_FAILED_DISPATCHING_TO_EXCEPTIONMAP.toString(new Object[]{this.m_status, VWException.DescribeThrowableAndItsCause(t2)});
                                logger.severe(this.m_className, m_method, this.m_status);
                            }
                            break block40;
                        }
                        this.m_status = this.m_status + cause;
                        logger.severe(this.m_className, m_method, this.m_status);
                    }
                }
                catch (Throwable t) {
                    logger.throwing(this.m_className, m_method, t);
                    try {
                        if (t instanceof InvocationTargetException) {
                            t = ((InvocationTargetException)t).getTargetException();
                        }
                        String cause = VWException.DescribeThrowableAndItsCause(t);
                        this.m_status = VWResources.VWS_ADAPTOR_RUN_DISPATCHSETOEXCEPTIONMAP.toString(new Object[]{this.m_id, this.wobId, workflowName, signature, this.exception_submap, cause, this.getLocaleDateStringNow()});
                        this.se.setException(this.exception_submap, VWAdaptorEx.getClientName() + cause);
                        this.se.doDispatch();
                        logger.info(this.m_className, m_method, this.m_status);
                    }
                    catch (Throwable t2) {
                        this.m_status = VWResources.VWS_ADAPTOR_STATUS_FAILED_DISPATCHING_TO_EXCEPTIONMAP.toString(new Object[]{this.m_status, VWException.DescribeThrowableAndItsCause(t2)});
                        logger.severe(this.m_className, m_method, this.m_status);
                    }
                }
                finally {
                    this.currentExecutionStartTime = -1L;
                    opname = this.m_parent;
                    synchronized (opname) {
                        this.m_parent.notifyAll();
                    }
                }
            }
            this.setAvailableAgain();
        }
        this.m_status = VWResources.VWS_ADAPTOR_RUN_STOPPED.toString(this.m_className, this.getLocaleDateStringNow());
    }

    private void init() throws Exception {
        VWCapsule capsule;
        String m_method = "init";
        this.done = false;
        this.startTime = System.currentTimeMillis();
        this.callTime = 0.0;
        this.callCount = 0.0;
        this.currentExecutionStartTime = -1L;
        if (this.component_descriptor_doc == null) {
            throw new VWException("vw.integrator.base.NoComponentDescriptor", "Unable to obtain valid component descriptor for {0}.", this.m_id);
        }
        String context = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_configcontext");
        String username = null;
        String realPw = null;
        String password = null;
        VWAuthItem itm = this.m_parent.getPrivateCredentials();
        if (itm != null) {
            username = itm.getName();
            realPw = itm.getPassword();
            if (realPw != null) {
                capsule = new VWCapsule(realPw);
                password = capsule.getStr();
            }
        }
        if (username == null || realPw == null) {
            username = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_username");
            password = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "jaas_password");
            capsule = new VWCapsule();
            capsule.setString(password);
            realPw = capsule.getString();
        }
        this.m_status = VWResources.VWS_ADAPTOR_RUN_GETTING_JAAS_CONTEXT.toString(new Object[]{this.m_id, context, this.getLocaleDateStringNow()});
        this.lc = new LoginContext(context, new VWCallbackHandler(username, password));
        this.m_status = VWResources.VWS_ADAPTOR_RUN_PERFORMJAASLOGIN.toString(new Object[]{this.m_id, context, username, this.getLocaleDateStringNow()});
        this.lc.login();
        this.session = VWLoginModule.getSession(this.lc);
        if (this.session == null) {
            this.session = new VWSession(username, realPw, this.connection_point);
        }
        this.exception_submap = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "exception_submap");
        if (this.exception_submap == null || this.exception_submap.length() == 0) {
            this.exception_submap = "Malfunction";
        }
        this.adaptor_class_name = VWXMLWrapper.getNodeValue(this.component_descriptor_doc.getRootNode(), "adaptor_class");
        if (this.adaptor_class_name == null) {
            throw new VWException("vw.integrator.base.AdaptorClassNotDefined", "Adaptor class not specified in component descriptor.");
        }
        Class<?> adaptor_class = Class.forName(this.adaptor_class_name);
        if (adaptor_class == null) {
            throw new VWException("vw.integrator.base.CantLoadAdaptorClass", "Unable to load adaptor class: {0}.", this.adaptor_class_name);
        }
        this.adaptor = (IVWAdaptor)adaptor_class.newInstance();
        if (this.adaptor == null) {
            throw new VWException("vw.integrator.base.CantCreateAdaptorInstance", "Unable to create instance of adaptor: {0}.", this.adaptor_class_name);
        }
        AdaptorInitAction init_action = new AdaptorInitAction(this.adaptor, this.component_descriptor);
        try {
            Subject.doAsPrivileged(this.lc.getSubject(), init_action, null);
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public void stopEx() {
        String m_method = "stop";
        logger.entering(this.m_className, "stop");
        if (!this.isIdle()) {
            logger.severe(VWResources.VWS_WFDISPATCHER_STOP_ADAPTOR.toString(this.m_status));
        }
        try {
            if (this.isIdle() && this.adaptor != null) {
                this.adaptor.stop();
                this.adaptor = null;
            }
        }
        catch (Exception ex) {
            logger.throwing(this.m_className, "stop", ex);
        }
        if (this.session != null) {
            try {
                this.session.logoff();
            }
            catch (VWException e) {
                e.printStackTrace();
            }
        }
        this.session = null;
        this.done = true;
        logger.exiting(this.m_className, "stop");
        this.m_status = VWResources.VWS_ADAPTOR_RUN_STOPPED.toString(this.m_className, this.getLocaleDateStringNow());
    }

    public synchronized long getAverageCallsPerMinute() throws Exception {
        long elapsedTimeInMinutes = (System.currentTimeMillis() - this.startTime) / 60000L;
        if (elapsedTimeInMinutes == 0L) {
            return (long)this.callCount;
        }
        return (long)(this.callCount / (double)elapsedTimeInMinutes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAverageCallTimeMillis() throws Exception {
        Object object = this.statsSyncObj;
        synchronized (object) {
            if (this.callCount == 0.0) {
                return 0L;
            }
            return (long)(this.callTime / this.callCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetCallTimeStatistics() throws Exception {
        Object object = this.statsSyncObj;
        synchronized (object) {
            this.startTime = System.currentTimeMillis();
            this.callTime = 0.0;
            this.callCount = 0.0;
        }
    }

    public boolean isRunning() {
        return !this.done;
    }

    public boolean isIdle() {
        return this.bIsIdle;
    }

    public long currentMethodExecutionTime() {
        if (this.currentExecutionStartTime > 0L) {
            return System.currentTimeMillis() - this.currentExecutionStartTime;
        }
        return 0L;
    }

    public void startEx() {
        super.start();
    }

    public void setNameEx(String s) {
        this.setName(s);
    }

    public String toString() {
        if (this.m_status != null) {
            return this.m_status + ". " + this.callCount + " RPCs (" + this.callTime + "ms).";
        }
        return this.getName();
    }

    class AdaptorInitAction
    implements PrivilegedExceptionAction {
        protected IVWAdaptor adaptor = null;
        protected String descriptor = null;

        public AdaptorInitAction(IVWAdaptor adaptor, String descriptor) {
            this.adaptor = adaptor;
            this.descriptor = descriptor;
        }

        public Object run() throws Exception {
            this.adaptor.init(this.descriptor);
            return null;
        }
    }

    class AdaptorAction
    implements PrivilegedExceptionAction {
        protected IVWAdaptor adaptor = null;
        protected VWStepElement se = null;
        protected String signature = null;

        public AdaptorAction(IVWAdaptor adaptor, VWStepElement se, String signature) {
            this.adaptor = adaptor;
            this.se = se;
            this.signature = signature;
        }

        public Object run() throws Exception {
            this.adaptor.execute(this.se, this.signature);
            return null;
        }
    }
}

